//
//  MCAlertObjectProtocol.h
//  MCFoundation
//
//  Created by Michael Clark on 07/09/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCAlertDefines.h"
#import "MCAlertableObjectProtocol.h"
#import "MCPersistentObject.h"
#import "MCPUserProtocol.h"

@protocol MCAlertObjectProtocol <NSObject, MCPersistentObject>


- (BOOL)hasBeenSeen;
- (BOOL)hasNotBeenSeen;
- (void)markAsSeen;
- (void)markAsNotSeen;

- (BOOL)hasBeenRead;
- (BOOL)hasNotBeenRead;
- (void)markAsRead;
- (void)markAsNotRead;

- (NSCalendarDate*)alertSendDate;
- (void)setAlertSendDate: (NSCalendarDate*)aDate;

// It would be good practice to cache this object, and have the cache reset when setAlertableObjectEntityName or setAlertableObjectPrimaryKey are called
- (id <MCAlertableObjectProtocol>)alertableObject;
// As a convenience, it is expected that this method will also set the alertableObjectEntityName and alertableObjectPrimaryKey
- (void)setAlertableObject: (id <MCAlertableObjectProtocol>)anAlertableObject;

- (NSDictionary*)userInfo;
- (void)setUserInfo: (NSDictionary*)aUserInfo;

- (NSString*)alertableObjectEntityName;
- (void)setAlertableObjectEnityName: (NSString*)anEntityName;

- (NSNumber*)alertableObjectPrimaryKey;
- (void)setAlertableObjectPrimaryKey: (NSNumber*)aPrimaryKey;

- (MCAlertType)alertType;
- (void)setAlertType: (MCAlertType)aType;

- (NSNumber*)alertTypeCode;
- (void)setAlertTypeCode: (NSNumber*)aTypeCode;

- (NSString*)reason;
- (void)setReason: (NSString*)aReason;

- (NSString*)message;
- (void)setMessage: (NSString*)aMessage;

- (id <MCPUserProtocol>)sendingUser;
- (void)setSendingUser: (id <MCPUserProtocol>)aUser;

- (id <MCPUserProtocol>)receivingUser;
- (void)setReceivingUser: (id <MCPUserProtocol>)aUser;

- (NSString *)alertEmailSubjectString;
- (NSAttributedString *)alertEmailBodyString;
@end
